USE [IronPbx]
GO
/****** Object:  StoredProcedure [dbo].[CallAuthorize]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[CallAuthorize] 
    @CbUserId int,
	@DisplayName nvarchar(80),
	@Ani nvarchar(32),
	@CalledNumber nvarchar(32),
	@Login nvarchar(80),
	@IPaddr nvarchar(16),
	@IPport int,
	@Proto int,
	@Realm nvarchar(80),
	@Uri nvarchar(80),
	@Method nvarchar(32),
	@Nonce nvarchar(33),
	@Response nvarchar(33)
--     .
-- OUTPUT DATA:
-- callednumber,
-- displayname,   phonenumber,   internal,   routemask,
-- displayname_a, phonenumber_a, internal_a, routemask_a,
-- password, routemode
AS 
BEGIN
	DECLARE @userid int;
	DECLARE @dspname nvarchar(80);
	DECLARE @phonenum nvarchar(32);
	DECLARE @internal int;
	DECLARE @routemask int;
	DECLARE @int1 int;
	DECLARE @departmentid int;
	DECLARE @passw nvarchar(80);
	DECLARE @anitransid int;
	DECLARE @cbflag bit;
	DECLARE @maxchan int;
	DECLARE @maxconn int;
	DECLARE @maxinph int;
	DECLARE @gwname nvarchar(80);
	DECLARE @codec1 int;
	DECLARE @codec2 int;
	DECLARE @codec3 int;
	DECLARE @codec4 int;
	DECLARE @frame1 int;
	DECLARE @frame2 int;
	DECLARE @frame3 int;
	DECLARE @frame4 int;

	DECLARE @HashThis nvarchar(33);
	DECLARE @A1 nvarchar(33);
	DECLARE @A2 nvarchar(33);

	SET @maxchan=0;
	SET @maxconn=0;
	SET @maxinph=0;
	SET @userid=0;
	SET @dspname=@IPaddr;
	SET @phonenum=@Ani;
	SET @internal=0;
	SET @cbflag=0;
	SET @routemask=0;
	SET @int1=0;
	SET @departmentid=0;
	SET @anitransid=0;

	IF(@CbUserId<>0)
	BEGIN
		SELECT TOP 1  @gwname='',@userid=UserId,@dspname=Users.Name ,
			   @phonenum=PhoneNumber,@internal=Internal,@routemask=(RouteMask*65536+RightGroups.DepartmentId),
			   @departmentid=RightGroups.DepartmentId,@int1=Users.RightId,
			   @codec1=0,@codec2=0,@codec3=0,@codec4=0, 
			   @frame1=0,@frame2=0,@frame3=0,@frame4=0 
		FROM Users, RightGroups
		WHERE UserId=@CbUserId;
		GOTO LabelFindUser;
	END
	IF(LEN(@Login)=0)
	BEGIN
		SELECT TOP 1  @gwname='Line:'+IntGateways.gwName,@userid=Users.UserId,@dspname=Users.Name,
			   @phonenum=Users.PhoneNumber,@internal=Users.Internal,@routemask=(RouteMask*65536+RightGroups.DepartmentId),
			   @departmentid=RightGroups.DepartmentId,@int1=Users.RightId,
			   @codec1=Codec1,@codec2=Codec2,@codec3=Codec3,@codec4=Codec4, 
			   @frame1=Frame1,@frame2=Frame2,@frame3=Frame3,@frame4=Frame4 
		FROM IntGateways, Lines, Users, RightGroups, CodecClass
		WHERE IntGateways.Dns=@IPaddr AND IntGateways.Proto=@Proto AND 
			  (IntGateways.ipPort=@IPport OR @Proto=0) AND Lines.GwId=IntGateways.Id AND 
			  Lines.PortNumber=@Ani AND Users.UserId=Lines.UserId AND 
			  Users.RightId=RightGroups.Id AND IntGateways.CodecClassId=CodecClass.Id;
		IF(@userid<>0) GOTO LabelFindUser;
--		SELECT TOP 1  @gwname=IntGateways.gwName,@userid=0,@dspname=@DisplayName,
--			   @phonenum=@Ani,@internal=0,@routemask=IntGateways.DepartmentId,
--			   @departmentid=IntGateways.DepartmentId,@int1=0,
--			   @codec1=Codec1,@codec2=Codec2,@codec3=Codec3,@codec4=Codec4, 
--			   @frame1=Frame1,@frame2=Frame2,@frame3=Frame3,@frame4=Frame4 
--		FROM IntGateways, CodecClass
--		WHERE IntGateways.Dns=@IPaddr AND IntGateways.Proto=@Proto AND 
--			  (IntGateways.ipPort=@IPport OR @Proto=0) AND IntGateways.CodecClassId=CodecClass.Id;
		SELECT TOP 1  @gwname=IntGateways.gwName,@userid=IntGateways.Id+0x10000000,@dspname=@DisplayName,
			   @phonenum=@Ani,@internal=0,@routemask=(RouteMask*65536+RightGroups.DepartmentId),
			   @departmentid=RightGroups.DepartmentId,@int1=IntGateways.RightId,
			   @codec1=Codec1,@codec2=Codec2,@codec3=Codec3,@codec4=Codec4, 
			   @frame1=Frame1,@frame2=Frame2,@frame3=Frame3,@frame4=Frame4 
		FROM IntGateways, RightGroups, CodecClass
		WHERE IntGateways.Dns=@IPaddr AND IntGateways.Proto=@Proto AND 
			  (IntGateways.ipPort=@IPport OR @Proto=0) AND IntGateways.RightId=RightGroups.Id AND IntGateways.CodecClassId=CodecClass.Id;
		IF(@departmentid<>0) GOTO LabelFindUser;
		SELECT TOP 1  @gwname=ExtGateways.GwName,@userid=0,@dspname=ExtGateways.GwName,
			   @phonenum=@Ani,@internal=0,@routemask=DepartmentId,@CalledNumber=InPhone,
			   @departmentid=DepartmentId,@int1=0,@anitransid=AniTransId,
			   @codec1=Codec1,@codec2=Codec2,@codec3=Codec3,@codec4=Codec4, 
			   @frame1=Frame1,@frame2=Frame2,@frame3=Frame3,@frame4=Frame4 
		FROM ExtGateways, CodecClass
		WHERE ExtGateways.IPaddr=@IPaddr AND Proto=@Proto AND 
			   ExtGateways.Ani=@CalledNumber AND ExtGateways.CodecClassId=CodecClass.Id;
		IF(@departmentid<>0) 
		BEGIN
			SELECT TOP 1 @phonenum=TransformRule+RIGHT(@Ani,LEN(@Ani)-LEN(Prefix)) 
			FROM AniRules
			WHERE AniTrId=@anitransid AND @Ani LIKE Prefix+'%' AND (AniRules.Len=0 OR AniRules.Len=LEN(@Ani))  
			ORDER BY LEN(Prefix) DESC, AniRules.Len DESC;
			SELECT TOP 1  @cbflag=CallBack,@userid=UserId,@dspname=Users.Name,
			   @internal=Internal,@routemask=(RouteMask*65536+RightGroups.DepartmentId),
			   @int1=Users.RightId
			FROM Users, RightGroups
			WHERE Users.RightId=RightGroups.Id AND DepartmentId=@departmentid AND LEN(MobileNumber)>0 AND MobileNumber=@phonenum;
			IF(@cbflag<>0) SET @CalledNumber='cb'+@phonenum;
			GOTO LabelFindUser;
		END
	END
	ELSE 
	BEGIN
		SELECT TOP 1  @gwname='User:'+CAST(UserId AS VARCHAR),@userid=UserId,@dspname=Users.Name ,
			   @phonenum=PhoneNumber,@internal=Internal,@routemask=(RouteMask*65536+RightGroups.DepartmentId),
			   @departmentid=RightGroups.DepartmentId,@int1=Users.RightId,@passw=Users.Password,
			   @codec1=Codec1,@codec2=Codec2,@codec3=Codec3,@codec4=Codec4, 
			   @frame1=Frame1,@frame2=Frame2,@frame3=Frame3,@frame4=Frame4 
		FROM Users, RightGroups, CodecClass
		WHERE Users.Login=@Login AND Users.RightId=RightGroups.Id AND CodecClassId=CodecClass.Id;
		IF(@userid<>0)
		BEGIN
			IF (dbo.DigestAuthorizeMD5(@Login,@passw,@Realm,@Uri,@Method,@Nonce,@Response)='false') RETURN;
			GOTO LabelFindUser;
		END
		SELECT TOP 1  @gwname='Line:'+IntGateways.gwName,@userid=Users.UserId,@dspname=Users.Name,
			   @phonenum=Users.PhoneNumber,@internal=Users.Internal,@routemask=(RouteMask*65536+RightGroups.DepartmentId),
			   @departmentid=RightGroups.DepartmentId,@int1=Users.RightId,@passw=IntGateways.Password,
			   @codec1=Codec1,@codec2=Codec2,@codec3=Codec3,@codec4=Codec4, 
			   @frame1=Frame1,@frame2=Frame2,@frame3=Frame3,@frame4=Frame4 
		FROM IntGateways, Lines, Users, RightGroups, CodecClass
		WHERE IntGateways.Login=@Login AND Lines.GwId=IntGateways.Id AND 
			  Lines.PortNumber=@Ani AND Users.UserId=Lines.UserId AND 
			  Users.RightId=RightGroups.Id AND IntGateways.CodecClassId=CodecClass.Id;
		IF(@userid<>0)
		BEGIN
			IF (dbo.DigestAuthorizeMD5(@Login,@passw,@Realm,@Uri,@Method,@Nonce,@Response)='false') RETURN;
			GOTO LabelFindUser;
		END
--		SELECT TOP 1  @gwname=IntGateways.gwName,@userid=0,@dspname=@DisplayName,
--			   @phonenum=@Ani,@internal=0,@routemask=IntGateways.DepartmentId,
--			   @departmentid=IntGateways.DepartmentId,@int1=0,@passw=IntGateways.Password,
--			   @codec1=Codec1,@codec2=Codec2,@codec3=Codec3,@codec4=Codec4, 
--			   @frame1=Frame1,@frame2=Frame2,@frame3=Frame3,@frame4=Frame4 
--		FROM IntGateways, CodecClass
--		WHERE IntGateways.Login=@Login AND IntGateways.CodecClassId=CodecClass.Id;
		SELECT TOP 1  @gwname=IntGateways.gwName,@userid=IntGateways.Id+1000000,@dspname=@DisplayName,
			   @phonenum=@Ani,@internal=0,@routemask=(RouteMask*65536+RightGroups.DepartmentId),
			   @departmentid=RightGroups.DepartmentId,@int1=IntGateways.RightId,@passw=IntGateways.Password,
			   @codec1=Codec1,@codec2=Codec2,@codec3=Codec3,@codec4=Codec4, 
			   @frame1=Frame1,@frame2=Frame2,@frame3=Frame3,@frame4=Frame4 
		FROM IntGateways,RightGroups, CodecClass
		WHERE IntGateways.Login=@Login AND IntGateways.CodecClassId=CodecClass.Id AND IntGateways.RightId=RightGroups.Id;
		IF(@departmentid<>0)
		BEGIN
			IF (dbo.DigestAuthorizeMD5(@Login,@passw,@Realm,@Uri,@Method,@Nonce,@Response)='false') RETURN;
			GOTO LabelFindUser;
		END
	END

	RETURN;
	
LabelFindUser:

	SELECT @maxchan=MaxChan FROM Departments WHERE Id=@departmentid;
	SELECT @maxconn=COUNT(*) FROM Connections WHERE DepartmentId=@departmentid AND Line=32;
	IF(@maxchan<=@maxconn) RETURN;

	SELECT @internal=GongFlag
	FROM ConfPttPhones WHERE ConfPhoneNumber=@CalledNumber AND DepartmentId=@DepartmentId;

	SELECT @CalledNumber,@userid,@dspname,@phonenum,@internal,@routemask,@int1,
		   @gwname,@codec1,@codec2,@codec3,@codec4,@frame1,@frame2,@frame3,@frame4;

END

GO
/****** Object:  StoredProcedure [dbo].[GetGwInfo]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[GetGwInfo]
	@IpStr nvarchar(16),
	@IpPort int,
	@Proto int,
    @User nvarchar(80),
    @Host nvarchar(80),
	@Port int
AS
BEGIN
	IF(EXISTS(SELECT * FROM ExtGateways WHERE IPaddr=@IpStr AND Proto=@Proto AND 
				((Proto=1 AND Ani=@User) OR (Proto=0 AND fastStart=0))))
	BEGIN
		SELECT 0;
		RETURN;
	END
	IF(EXISTS(SELECT * FROM IntGateways WHERE ContactAddr=@IpStr AND Proto=@Proto AND 
				(Proto=0 OR ipPort=@IpPort) AND fastStart=0))
	BEGIN
		SELECT 0;
		RETURN;
	END
	SELECT 1;
END

GO
/****** Object:  StoredProcedure [dbo].[GetRecordTable]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[GetRecordTable] 
	@BeginTime nvarchar(32),
	@EndTime nvarchar(32),
	@FindStr nvarchar(128)
AS
BEGIN
	
	DECLARE @cdr table(Id int,SqlData datetime,DataTime int,LegId int,InitLegId int,
					DisplayName nvarchar(80),Phone nvarchar(32),Incoming bit,
					InitDisplayName nvarchar(256),InitPhone nvarchar(256),Duration int, 
					RecordFile nvarchar(256));

	INSERT INTO @cdr SELECT Id,SqlData,DataTime,LegId,InitLegId,DisplayName,Phone,Incoming,
			InitDisplayName,InitPhone,Duration,RecordFile 
	FROM	CallDataRecords 
	WHERE	SqlData>=CAST(@BeginTime AS DATETIME) AND 
			SqlData<DATEADD(dd,1,CAST(@EndTime AS DATETIME)) 
			AND Duration>5 AND LEN(RecordFile) <> 0;

	DECLARE @Id int;
	DECLARE @SqlData datetime;
	DECLARE @DataTime int;
	DECLARE @LegId int;
	DECLARE @InitLegId int;
	DECLARE @DisplayName nvarchar(256);
	DECLARE @Phone nvarchar(256);
	DECLARE @Incoming bit;

	DECLARE cdr_cursor CURSOR FOR
			SELECT Id,SqlData,DataTime,LegId,InitLegId,DisplayName,Phone, Incoming
			FROM @cdr ORDER BY Id;

	OPEN cdr_cursor;
	FETCH NEXT FROM cdr_cursor INTO @Id, @SqlData, @DataTime, @LegId, @InitLegId, @DisplayName, @Phone, @Incoming;
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF(@Incoming=0)
			SELECT @DisplayName=DisplayName, @Phone=Phone
			FROM CallDataRecords
			WHERE LegId=@InitLegId AND DataTime-Duration<@DataTime AND DataTime+Duration>@DataTime; 
		ELSE
			SELECT @DisplayName=DisplayName, @Phone=Phone
			FROM CallDataRecords
			WHERE InitLegId=@LegId AND Duration>0 AND DataTime-Duration<@DataTime AND DataTime+Duration>@DataTime; 

		UPDATE  @cdr SET InitDisplayName=@DisplayName,InitPhone=@Phone WHERE Id=@Id;

		FETCH NEXT FROM cdr_cursor INTO @Id, @SqlData, @DataTime, @LegId, @InitLegId, @DisplayName, @Phone, @Incoming;
	END
	CLOSE cdr_cursor;
	DEALLOCATE cdr_cursor;


	SELECT  ''=SqlData, ''=DisplayName,''=Phone, ''=Incoming,
			''=InitDisplayName, ''=InitPhone, ''=Duration, 
			' '=RecordFile 
	FROM	@cdr
	WHERE	DisplayName LIKE @FindStr+'%' OR Phone LIKE @FindStr+'%' OR 
			InitDisplayName  LIKE @FindStr+'%' OR InitPhone   LIKE @FindStr+'%'; 
END

GO
/****** Object:  StoredProcedure [dbo].[InterceptHandle]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[InterceptHandle]
	@TransferNum int
AS
BEGIN
	SELECT '', '', '', 0, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', '', '', '', 0, '', '', 0, 0, '', 0, @TransferNum, 0, 0, '', 0, '', 0, '', 0, '', 0, '', 0; 
END

GO
/****** Object:  StoredProcedure [dbo].[LineBusy]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineBusy]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='busy'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'busy',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END


GO
/****** Object:  StoredProcedure [dbo].[LineChange]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineChange]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET DepartmentId=@RoutePlan & 65535,DisplayInfo=@DisplayName,
		PhoneNumber=@PhoneNumber,Ani=@Ani,
		RoutePlan=@RoutePlan,Internal=@Internal,
		Mute=@Mute,ConfId=@ConfId,UserId=@UserId 
		WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'change',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END


GO
/****** Object:  StoredProcedure [dbo].[LineConference]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineConference]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='conference'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'conference',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END


GO
/****** Object:  StoredProcedure [dbo].[LineConnect]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineConnect]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
--	DECLARE @PhoneNumber nvarchar(32);
--	DECLARE @Internal bit;
--	DECLARE @Incoming bit;
	DECLARE @PttId bit;

	UPDATE Connections SET State='connect',ConnectTime=GetDate() 
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'connect',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);

--	SELECT @PhoneNumber=PhoneNumber, @Internal=Internal,@Incoming=Incoming, @PttId=ConfId FROM Connections WHERE AcsId=@AcsId;

	SET @PttId=@ConfId;

	IF(@Internal=0)
		SELECT '.\Record\'+CAST(CAST(GETDATE() AS DATE) AS NVARCHAR)+'\'+REPLACE(CAST(CAST(GETDATE() AS TIME(0)) AS NVARCHAR),':','-')+'-'+CAST(@AcsId AS NVARCHAR)+'-'+@PhoneNumber+'.wav';
	ELSE IF(@Internal=1 AND @PhoneNumber='129')
		SELECT '.\Record\'+CAST(CAST(GETDATE() AS DATE) AS NVARCHAR)+'\'+REPLACE(CAST(CAST(GETDATE() AS TIME(0)) AS NVARCHAR),':','-')+'-'+CAST(@AcsId AS NVARCHAR)+'-'+@PhoneNumber+'.wav';
	ELSE IF(@Incoming=1 AND @PttId<>0)
		SELECT '.\Record\'+CAST(CAST(GETDATE() AS DATE) AS NVARCHAR)+'\'+REPLACE(CAST(CAST(GETDATE() AS TIME(0)) AS NVARCHAR),':','-')+'-'+CAST(@AcsId AS NVARCHAR)+'-'+@PhoneNumber+'.wav';
	ELSE 
		SELECT '';
END


GO
/****** Object:  StoredProcedure [dbo].[LineDialed]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineDialed]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='dialed'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'dialed',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END


GO
/****** Object:  StoredProcedure [dbo].[LineDialtone]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineDialtone]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='dialtone'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'dialtone',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END

GO
/****** Object:  StoredProcedure [dbo].[LineIntrusion]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineIntrusion]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='intrusion'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'intrusion',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END

GO
/****** Object:  StoredProcedure [dbo].[LineMove]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineMove]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='move'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'move',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END

GO
/****** Object:  StoredProcedure [dbo].[LineNew]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineNew]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int,
	@InPhoneId int
AS
BEGIN
	DECLARE @InitUserId int;
	DECLARE @InitDisplayInfo nvarchar(80);
	DECLARE @InitPhoneNumber nvarchar(32);
	DECLARE @InitHandle int;

	SET @InitUserId=@UserId;
	SET @InitDisplayInfo=@DisplayName;
	SET @InitPhoneNumber=@PhoneNumber;
	SET @InitHandle=@Handle;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'new',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);

	IF(@Incoming=0)
		SELECT @InitUserId=UserId,@InitDisplayInfo=DisplayInfo,@InitPhoneNumber=PhoneNumber,
			@InitHandle=Handle FROM Connections WHERE AcsId=@SessId;
	
	INSERT INTO Connections (Channel,Line,DepartmentId,DisplayInfo,
		PhoneNumber,Ani,TransferNumber,State,SessId,AcsId,
		IPaddr,IPport,Handle,RoutePlan,InitTime,Internal,Incoming,
		ConfId,Mute,InitUserId,InitDisplayInfo,InitPhoneNumber,
		InitHandle,UserId,InPhoneId)
	VALUES (@Connection,@Line,@RoutePlan & 65535,@DisplayName,@PhoneNumber,
		@Ani,@TransferNumber,'new',@SessId,@AcsId,@IPstr,@IPport,
		@Handle,@RoutePlan,GetDate(),@Internal,@Incoming,@Mute,
		@ConfId,@InitUserId,@InitDisplayInfo,@InitPhoneNumber,
		@InitHandle,@UserId,@InPhoneId);
END

GO
/****** Object:  StoredProcedure [dbo].[LineParking]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineParking]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='parking'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'parking',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END

GO
/****** Object:  StoredProcedure [dbo].[LineRecord]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineRecord]
	@AcsId int
AS
BEGIN
	DECLARE @PhoneNumber nvarchar(32);
	
	SELECT @PhoneNumber=PhoneNumber FROM Connections WHERE AcsId=@AcsId;

	SELECT '.\Record\'+CAST(CAST(GETDATE() AS DATE) AS NVARCHAR)+'\'+REPLACE(CAST(CAST(GETDATE() AS TIME(0)) AS NVARCHAR),':','-')+'-'+CAST(@AcsId AS NVARCHAR)+'-'+@PhoneNumber+'.wav';
END

GO
/****** Object:  StoredProcedure [dbo].[LineRelease]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineRelease]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int,
	@Duration int
AS
BEGIN
	DELETE FROM Connections WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId,Duration)
	VALUES (GetDate(),@Connection,@Line,'release',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId,@Duration);
END

GO
/****** Object:  StoredProcedure [dbo].[LineRequest]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineRequest]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='request'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'request',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END

GO
/****** Object:  StoredProcedure [dbo].[LineTalk]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineTalk]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='talk'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'talk',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END

GO
/****** Object:  StoredProcedure [dbo].[LineWav]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LineWav]
	@Connection int,
	@Line int,
	@UserId int,
	@DisplayName nvarchar(80),
	@PhoneNumber nvarchar(32),
	@Ani nvarchar(32),
	@TransferNumber nvarchar(32),
	@IPstr nvarchar(32),
	@IPport int,
	@Handle int,
	@RoutePlan int,
	@Internal int,
	@SessId int,
	@AcsId int,
	@Incoming int,
	@Mute int,
	@ConfId int
AS
BEGIN
	UPDATE Connections SET Channel=@Connection,Line=@Line, State='wav'
	WHERE AcsId=@AcsId;

	INSERT INTO LineEvents (EventTime,Connection,Line,State,UserId,DisplayInfo,
		PhoneNumber,Handle,RoutePlan,Ani,TransferNumber,SessId,AcsId,
		IPaddr,IPport,Internal,Incoming,Mute,ConfId)
	VALUES (GetDate(),@Connection,@Line,'wav',@UserId,@DisplayName,
		@PhoneNumber,@Handle,@RoutePlan,@Ani,@TransferNumber,@SessId,@AcsId,
		@IPstr,@IPport,@Internal,@Incoming,@Mute,@ConfId);
END

GO
/****** Object:  StoredProcedure [dbo].[LoadWavFiles]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[LoadWavFiles] 
--      .
AS
BEGIN
    -- Insert statements for procedure here
	SELECT DISTINCT WavFileName FROM WavFiles
END

GO
/****** Object:  StoredProcedure [dbo].[RegisterAnswer]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RegisterAnswer] 
	@Id int,
	@GwName nvarchar(80),
	@Expires int,
	@IPaddr nvarchar(16)
AS
BEGIN
	IF((@Id & 0x10000000) = 0)
	BEGIN
		IF(@Expires<0) UPDATE ExtGateways SET IPaddr=@IPaddr, Register='false',NextRegTime=DATEADD (ss,30,GETDATE()) WHERE Id=@Id;
		ELSE IF(@Expires=0) UPDATE ExtGateways SET IPaddr=@IPaddr, Register='false', NextRegTime=DATEADD (ss,60,GETDATE()) WHERE Id=@Id;
		ELSE IF(@Expires>0) UPDATE ExtGateways SET IPaddr=@IPaddr, Register='true',NextRegTime=DATEADD (ss,@Expires-15,GETDATE())  WHERE Id=@Id;
	END
	ELSE
	BEGIN
		SET @Id=@Id-0x10000000;
		IF(@Expires<0) UPDATE IntGateways SET ContactAddr=@IPaddr, Register='false',NextRegTime=DATEADD (ss,30,GETDATE()) WHERE Id=@Id;
		ELSE IF(@Expires=0) UPDATE IntGateways SET ContactAddr=@IPaddr, Register='false', NextRegTime=DATEADD (ss,60,GETDATE()) WHERE Id=@Id;
		ELSE IF(@Expires>0) UPDATE IntGateways SET ContactAddr=@IPaddr, Register='true',NextRegTime=DATEADD (ss,@Expires-15,GETDATE())  WHERE Id=@Id;
	END
END


GO
/****** Object:  StoredProcedure [dbo].[RegisterGetGateways]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RegisterGetGateways]
AS
BEGIN
	DECLARE @Time DATETIME;

	SET @Time=GETDATE();

	SELECT Id,gwName,Dns,ipPort,Login,Password,Ani,ExpiresInterval
	FROM ExtGateways 
	WHERE Proto=1 AND ExpiresInterval>45 AND LEN(Login)>0 AND LEN(Password)>0 AND 
		(Register='false' OR NextRegTime IS NULL OR NextRegTime < @Time) AND
		gwName<>'Default' AND gwName<>'NextCall'
	UNION
	SELECT Id+0x10000000,gwName,Dns,ipPort,Login,Password,'',ExpiresInterval
	FROM IntGateways 
	WHERE Proto=1 AND ExpiresInterval>45 AND LEN(Login)>0 AND LEN(Password)>0 AND 
		(Register='false' OR NextRegTime IS NULL OR NextRegTime < @Time) AND
		gwName<>'Default' AND gwName<>'NextCall'
	UNION
	--  IP   DNS
	SELECT Id,gwName,Dns,0,'','','',0
	FROM ExtGateways 
	WHERE (ExpiresInterval=0 OR Proto=0) AND (NextRegTime IS NULL OR NextRegTime < @Time) AND
		gwName<>'Default' AND gwName<>'NextCall'
	UNION
	SELECT Id+0x10000000,gwName,Dns,0,'','','',0
	FROM IntGateways 
	WHERE (ExpiresInterval=0 OR Proto=0) AND (NextRegTime IS NULL OR NextRegTime < @Time) AND
		gwName<>'Default' AND gwName<>'NextCall';
END
GO
/****** Object:  StoredProcedure [dbo].[RegisterGetNumOfGateways]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RegisterGetNumOfGateways] 
AS
BEGIN
	--SELECT COUNT(*) FROM ExtGateways; 

	SELECT SUM(countrow) FROM (SELECT COUNT(*) AS countrow FROM ExtGateways UNION SELECT COUNT(*) AS countrow FROM IntGateways) AS Gateways;
END

GO
/****** Object:  StoredProcedure [dbo].[RegisterSipAuthorize]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RegisterSipAuthorize] 
	@DisplayName nvarchar(80),
	@Phone nvarchar(32),
	@Login nvarchar(80),
	@IPaddr nvarchar(16),
	@IPport int,
	@ContactAddr nvarchar(80),
	@Expires int,
	@Nat bit,
	@Realm nvarchar(80),
	@Uri nvarchar(80),
	@Method nvarchar(32),
	@Nonce nvarchar(33),
	@Response nvarchar(33)
AS
BEGIN
	DECLARE @GwName nvarchar(80);
	DECLARE @UserId int;
	DECLARE @Password nvarchar(80);
	DECLARE @HashThis nvarchar(33);
	DECLARE @A1 nvarchar(33);
	DECLARE @A2 nvarchar(33);
	DECLARE @Time DATETIME;
	DECLARE @PttMode bit;

	IF(@Expires=0) SET @Expires=0;
	ELSE IF(@Nat=0) SELECT @Expires=CASE WHEN @Expires>600 THEN 600 ELSE @Expires END;
	ELSE SET @Expires=60;

	SET @Time=DATEADD(s,@Expires,GETDATE());

	SET @GwName='';
	SET @Password='';

	SELECT TOP 1 @GwName=gwName,@Password=Password FROM IntGateways WHERE Login=@Login;
	
	IF(@GwName<>'' AND @Password<>'')
	BEGIN
		IF (dbo.DigestAuthorizeMD5(@Login,@Password,@Realm,@Uri,@Method,@Nonce,@Response)='true')
		BEGIN
			UPDATE IntGateways SET Dns=@IPaddr, ipPort=@IPport, ContactAddr=@ContactAddr, Expires=@Time WHERE @GwName=gwName;
			SELECT @Expires;
			RETURN;
		END
		SELECT -1;
		RETURN;
	END

	SELECT TOP 1 @UserId=UserId,@Password=Password,@PttMode=PttMode FROM Users WHERE Login=@Login;
	
	IF(@UserId<>0 AND @Password<>'')
	BEGIN
		IF (dbo.DigestAuthorizeMD5(@Login,@Password,@Realm,@Uri,@Method,@Nonce,@Response)='true')
		BEGIN
		    IF(@PttMode=0 AND EXISTS(SELECT * FROM UsersGateways WHERE UserId=@UserId)) 
				UPDATE UsersGateways SET Dns=@IPaddr, ipPort=@IPport, ContactAddr=@ContactAddr, ContactPhone=@Phone, Expires=@Time WHERE UserId=@UserId;
			ELSE IF(EXISTS(SELECT * FROM UsersGateways WHERE UserId=@UserId AND Dns=@IPaddr AND ipPort=@IPport ))
				UPDATE UsersGateways SET Dns=@IPaddr, ipPort=@IPport, ContactAddr=@ContactAddr, ContactPhone=@Phone, Expires=@Time WHERE UserId=@UserId AND Dns=@IPaddr AND ipPort=@IPport;
			ELSE 
				INSERT UsersGateways (UserId,Dns,ipPort,ContactAddr,ContactPhone,Expires) VALUES (@UserId,@IPaddr,@IPport,@ContactAddr,@Phone,@Time);
			DELETE UsersGateways WHERE Expires<=GETDATE();
			SELECT @Expires;
			RETURN;
		END
		SELECT -1;
		RETURN;
	END

	SELECT 0;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteAnswer]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteAnswer]
	@CalledNumber nvarchar(32),
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@InitInternal int,
	@InitRouteMask int
AS
BEGIN
	DECLARE @route table(called varchar(32),gwname varchar(80),dns varchar(128),ipport int,contactaddr varchar(80),
			codec1 int,codec2 int,codec3 int,codec4 int,frame1 int,frame2 int,frame3 int,frame4 int,
			proto int, faststart int, nonatproxy bit, minjittbuff int,
			dispinfo varchar(80),calling varchar(32),
			ulogin varchar(80),passwd varchar(80),
			userid int,dispname varchar(80),
			phone varchar(32),routemask int,internal int,
            userdata  varchar(128),resolvetime int,firstring int,lastring int,
			extid int,str1 varchar(32),int1 int,str2 varchar(32),int2 int,
			str3 varchar(32),int3 int,str4 varchar(32),int4 int,str5 varchar(32),int5 int);

	DECLARE @DepartmentId int;
	DECLARE @userid int;
	DECLARE @dspname nvarchar(80);
	DECLARE @phonenum nvarchar(32);
	DECLARE @internal int;
	DECLARE @routemask int;
	DECLARE @extrouteid int;
	DECLARE @CodecClassId int;
	DECLARE @MinJittBuf int;
	DECLARE @SoftPh bit;
	DECLARE @Line bit;

	SET @userid=0;
	SET @DepartmentId=@InitRouteMask & 65535;
	SET @extrouteid=0;


	IF(@InitDisplayName='' AND @InitPhoneNumber='')
	BEGIN
		SET @InitDisplayName='VOIP System';
		SET @InitPhoneNumber='PBX'
	END 

	SELECT @userid=UserId, @dspname=Name,@phonenum=PhoneNumber,
		   @internal=Internal,@routemask=(RouteMask*65536+@DepartmentId),
		   @extrouteid=RightId,@SoftPh=ConfSoftPh, @Line=ConfLine,
		   @CodecClassId=CodecClassId, @MinJittBuf=MinJittBuf 
	FROM Users, RightGroups
	WHERE PhoneNumber=@CalledNumber AND RightGroups.DepartmentId=@DepartmentId AND 
		RightId=RightGroups.Id  AND @InitInternal<>0;

	IF(@userid<>0)
	BEGIN
		IF(@SoftPh<>0)
			INSERT INTO @route
				SELECT ContactPhone,
					RTRIM('User:'+CAST(@userid AS VARCHAR)),Dns,ipPort,ContactAddr,
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,1,1,0,@MinJittBuf,
					@InitDisplayName,@InitPhoneNumber,'','',
					@userid,@dspname,@phonenum,@routemask,@internal,
					'',0,0,20,0,'',@extrouteid,'',0,'',0,'',0,'',0
				FROM CodecClass, UsersGateways 
				WHERE Id=@CodecClassId AND UserId=@userid AND Expires>=GETDATE();
 		ELSE IF(@Line<>0)
			INSERT INTO @route
				SELECT PortNumber,'Line:'+IntGateways.GwName,Dns,ipPort,ContactAddr,
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
				    Proto,fastStart,NoNatProxy,MinJittBuf,
					@InitDisplayName,@InitPhoneNumber,'','',
					@userid,@dspname,@phonenum,@routemask,@internal,
					'',0,0,20,0,'',@extrouteid,'',0,'',0,'',0,'',0 
				FROM Lines, IntGateways, CodecClass
				WHERE UserId=@userid AND Lines.GwId=IntGateways.Id AND 
					(LEN(Login)=0 OR Expires>=GETDATE()) AND CodecClassId=CodecClass.Id;

	END
	
	SELECT * FROM @route;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteAuthorize ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteAuthorize ]
	@CalledNumber nvarchar(32)
AS
BEGIN
	SELECT TOP 1 UserId,Name,PhoneNumber,(RouteMask*65536+DepartmentId),Internal,7
	FROM Users, RightGroups
	WHERE Login+Password=@CalledNumber AND RightId=RightGroups.Id;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteConf]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteConf]
	@CalledNumber nvarchar(32),			--   ,     
	@InitUserId int,
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@InitInternal int,
	@InitRouteMask int,
	@PayUserId int
AS
BEGIN
	DECLARE @route table(called varchar(32),gwname varchar(80),dns varchar(128),ipport int,contactaddr varchar(80),
			codec1 int,codec2 int,codec3 int,codec4 int,frame1 int,frame2 int,frame3 int,frame4 int,
			proto int, faststart int, nonatproxy bit, minjittbuff int,
			dispinfo varchar(80),calling varchar(32),
			ulogin varchar(80),passwd varchar(80),
			userid int,dispname varchar(80),
			phone varchar(32),routemask int,internal int,
            userdata  varchar(128),resolvetime int,firstring int,lastring int,
			extid int,str1 varchar(32),int1 int,str2 varchar(32),int2 int,
			str3 varchar(32),int3 int,str4 varchar(32),int4 int,str5 varchar(32),int5 int);

	DECLARE @DepartmentId int;
	DECLARE @phoneid int,@userid int;
	DECLARE @DisplayInfo varchar(80);
	DECLARE @MaxConfTime int;
	DECLARE @GongFlag bit;
	DECLARE @GwId int;
	DECLARE @Init int;

	SET @DepartmentId=@InitRouteMask & 65535;
	SET @phoneid=0;

	SELECT @phoneid=Id, @DisplayInfo=DisplayInfo, @MaxConfTime=MaxConfTime, @GongFlag=GongFlag, @GwId=GwId
		FROM ConfPttPhones WHERE ConfPhoneNumber=@CalledNumber AND DepartmentId=@DepartmentId;

	IF(@phoneid<>0 AND EXISTS(SELECT UserId FROM ConfPttRoutes WHERE PhoneId=@phoneid AND UserId=@InitUserId))
	BEGIN
		DECLARE groupnum_cursor CURSOR FOR
			SELECT UserId
			FROM ConfPttRoutes WHERE PhoneId=@phoneid;

		OPEN groupnum_cursor;
		FETCH NEXT FROM groupnum_cursor INTO @userid;
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF(@userid<>@InitUserId)
			BEGIN
				INSERT INTO @route
					EXEC RouteUserConf @userid,@DisplayInfo,@CalledNumber,@MaxConfTime,@GongFlag,@GwId;
			END
			FETCH NEXT FROM groupnum_cursor INTO @userid;
		END
		CLOSE groupnum_cursor;
		DEALLOCATE groupnum_cursor;
		SELECT * FROM @route;
	END
END

GO
/****** Object:  StoredProcedure [dbo].[RouteExternal ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteExternal ] 
	-- ,  @InitUserId    @ForwardUserId,
	--   ,        
	--  @Called.....,       
	--    ,    @Called..... 
	@CalledNumber nvarchar(32),			--  
	@PrevRouteMode int,
	@ExtRouteId int,					--    
	@InitUserId int,					-- ID  
	@PayUserId int,						-- ID  ,      @InitUserId,    
	@CalledUserId int,						--  			--
	@CalledDisplayInfo nvarchar(80),		-- 							--
	@CalledPhone nvarchar(32),				--   			-- 
	@CalledRouteMask int,					--      --
	@CalledInternal int,					--     	--
	@CalledExtRouteId int,					-- 							--
	@FirstRing int,						--      
	@LastRing int,						--     
	@NumOfExt int						--  ID    
AS
BEGIN
	DECLARE @id int;
	DECLARE @prefix nvarchar(32);
	DECLARE @depid int;
	DECLARE @department nvarchar(80);

	SET @id=0;
	SET @CalledNumber=RTRIM(@CalledNumber);	--  ,    
												--      
	SELECT @depid=Id, @department=Description FROM Departments WHERE Id=(@CalledRouteMask & 65535);
	
	--    ,        
	--       (NumberPlanId=@ExtRouteId )  
	--     (ExtRoutes)
	SELECT TOP 1 @id=Id, @prefix=Prefix FROM ExtRoutes 
	WHERE RightId=@ExtRouteId AND @CalledNumber LIKE Prefix+'%' 
	ORDER BY LEN(Prefix) DESC;

	IF(@id<>0) --   (ID)    ,    
	BEGIN
		
--		IF(@InitUserId=@PayUserId)
		IF(@PrevRouteMode<>-1 AND @PrevRouteMode<>11)
		BEGIN
			SET @CalledUserId=0;
			SET @CalledDisplayInfo=''
			SET @CalledPhone=@CalledNumber;
			SET @CalledRouteMask=@CalledRouteMask & 65535;
			SET @CalledInternal=0;
			SET @CalledExtRouteId=0;
		END 
		--       (@prefix)
		SELECT ReplacePrefix+RIGHT(@CalledNumber,LEN(@CalledNumber)-LEN(@prefix)),
			g.GwName,g.Dns,g.ipPort,'',Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
			g.Proto,g.fastStart,g.NoNatProxy,g.MinJittBuf,
			@department,Ani,Login,Password,@CalledUserId,
			'DisplayInfo'=CASE WHEN @CalledDisplayInfo<>'' THEN @CalledDisplayInfo ELSE g.GwName END,
			@CalledPhone,@CalledRouteMask,@CalledInternal,'',0,@FirstRing,@LastRing,@NumOfExt,
			'',@CalledExtRouteId,'',@PayUserId,'',0,'',0,'',0 
		FROM ExtRoutes AS e, ExtGateways AS g, CodecClass
		WHERE e.RightId=@ExtRouteId AND Prefix=@prefix AND 
			e.GwId=g.Id AND CodecClassId=CodecClass.Id
			ORDER BY Priority ASC; 
	END
END

GO
/****** Object:  StoredProcedure [dbo].[RouteFax ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteFax ]
	@CalledNumber nvarchar(32),
	@InitDisplayName nvarchar(80),
	@InitRouteMask int,
	@UserId int
AS
BEGIN
	SELECT TOP 1 '000','Line:FaxVoiceServer','127.0.0.1',1730,'',2,3,0,0,20,20,0,0,0,1,0,0,
		CAST(@UserId AS nvarchar(32)),@CalledNumber,'','',
		0,@InitDisplayName +':FaxMail',@CalledNumber,0,(@InitRouteMask & 65535);
END

GO
/****** Object:  StoredProcedure [dbo].[RouteFromDoor ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteFromDoor ]
	@CalledNumber nvarchar(32),			--   ,     
	@InitUserId int,
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@InitInternal int,
	@InitRouteMask int,
	@PayUserId int,
	@AcsId int
AS
BEGIN
	DECLARE @route table(called varchar(32),gwname varchar(80),dns varchar(128),ipport int,contactaddr varchar(80),
			codec1 int,codec2 int,codec3 int,codec4 int,frame1 int,frame2 int,frame3 int,frame4 int,
			proto int, faststart int, nonatproxy bit, minjittbuff int,
			dispinfo varchar(80),calling varchar(32),
			ulogin varchar(80),passwd varchar(80),
			userid int,dispname varchar(80),
			phone varchar(32),routemask int,internal int,
            userdata  varchar(128),resolvetime int,firstring int,lastring int,
			extid int,str1 varchar(32),int1 int,str2 varchar(32),int2 int,
			str3 varchar(32),int3 int,str4 varchar(32),int4 int,str5 varchar(32),int5 int);

	DECLARE @DepartmentId int;
	DECLARE @phoneid int,@userid int, @firstring int, @lastring int;
	DECLARE @SessId int;
	
	SET @DepartmentId=@InitRouteMask & 65535;
	SET @phoneid=0;

	SELECT @SessId=SessId FROM Connections WHERE AcsId=@AcsId;

	SELECT @InitDisplayName=DisplayInfo+'-'+PhoneNumber FROM Connections WHERE SessId=@SessId AND Line=34 AND Internal=0;

	SELECT @phoneid=Id FROM GroupPhones WHERE PhoneNumber=@CalledNumber AND DepartmentId=@DepartmentId;

	IF(@phoneid<>0)
	BEGIN
		DECLARE groupnum_cursor CURSOR FOR
			SELECT UserId, FirstGroupRing, LastGroupRing 
			FROM GroupRoutes WHERE PhoneId=@phoneid
			ORDER BY FirstGroupRing, LastGroupRing;

		OPEN groupnum_cursor;
		FETCH NEXT FROM groupnum_cursor INTO @userid, @firstring, @lastring;
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @route
				EXEC RouteGroup @userid,@InitDisplayName,@InitPhoneNumber,@firstring,@lastring;
			FETCH NEXT FROM groupnum_cursor INTO @userid, @firstring, @lastring;
		END
		CLOSE groupnum_cursor;
		DEALLOCATE groupnum_cursor;
		UPDATE @route SET internal=0;
		SELECT * FROM @route;
	END
END

GO
/****** Object:  StoredProcedure [dbo].[RouteGroup]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteGroup]
	@CalledUserId int,
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@FirstRing int,
	@LastRing int
AS
BEGIN
	DECLARE @route table(called varchar(32),gwname varchar(80),dns varchar(128),ipport int,contactaddr varchar(80),
			codec1 int,codec2 int,codec3 int,codec4 int,frame1 int,frame2 int,frame3 int,frame4 int,
			proto int, faststart int, nonatproxy bit, minjittbuff int,
			dispinfo varchar(80),calling varchar(32),
			ulogin varchar(80),passwd varchar(80),
			userid int,dispname varchar(80),
			phone varchar(32),routemask int,internal int,
            userdata  varchar(128),resolvetime int,firstring int,lastring int,
			extid int,str1 varchar(32),int1 int,str2 varchar(32),int2 int,
			str3 varchar(32),int3 int,str4 varchar(32),int4 int,str5 varchar(32),int5 int);

	DECLARE @dspname nvarchar(80);
	DECLARE @phonenum nvarchar(32);
	DECLARE @internal int;
	DECLARE @routemask int;
	DECLARE @departmentid int;
	DECLARE @mobphone nvarchar(32);
	DECLARE @grsp bit;
	DECLARE @grline bit;
	DECLARE @grmob bit;
	DECLARE @extrouteid int;
	DECLARE @id int;
	DECLARE @prefix nvarchar(32);
	DECLARE @CodecClassId int;
	DECLARE @MinJittBuf int;

	SET @phonenum='NONE';

	--     (@CalledUserId)
	SELECT @dspname=Name,@phonenum=PhoneNumber,
		   @internal=Internal,@routemask=(RouteMask*65536+DepartmentId),
		   @departmentid=DepartmentId,@extrouteid=RightId,@mobphone=MobileNumber,
		   @grsp=GroupSoftPh,@grline=GroupLine,@grmob=GroupMob, 
		   @CodecClassId=CodecClassId, @MinJittBuf=MinJittBuf 
	FROM Users, RightGroups
	WHERE @CalledUserId=UserId AND RightId=RightGroups.Id;

	IF(@phonenum<>'NONE')
	BEGIN
		IF(@grsp<>0) --   
			INSERT INTO @route
				SELECT ContactPhone,
					RTRIM('User:'+CAST(@CalledUserId AS VARCHAR)),Dns,ipPort,ContactAddr,
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,1,1,0,@MinJittBuf,
					@InitDisplayName,@InitPhoneNumber,'','',
					@CalledUserId,@dspname,@phonenum,@routemask,@internal,'',0,
					@FirstRing,@LastRing,0,'',@extrouteid,'',0,'',0,'',0,'',0 
				FROM CodecClass, UsersGateways 
				WHERE Id=@CodecClassId AND UserId=@CalledUserId AND Expires>=GETDATE();
		IF(@grline<>0) --    
			INSERT INTO @route
				SELECT PortNumber,'Line:'+IntGateways.GwName,Dns,ipPort,ContactAddr,
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
				    Proto,fastStart,NoNatProxy,MinJittBuf,
					@InitDisplayName,@InitPhoneNumber,'','',
					@CalledUserId,@dspname,@phonenum,@routemask,@internal,'',0,
					@FirstRing,@LastRing,0,'',@extrouteid,'',0,'',0,'',0,'',0 
				FROM Lines, IntGateways, CodecClass
				WHERE UserId=@CalledUserId AND Lines.GwId=IntGateways.Id AND 
					(LEN(Login)=0 OR Expires>=GETDATE()) AND CodecClassId=CodecClass.Id;

		IF(@grmob<>0 AND @mobphone<>'' AND @extrouteid<>0) --   
			-- ,     (@extrouteid)
		BEGIN
			SET @id=0;

			SET @mobphone=RTRIM(@mobphone);	--  ,    
											--      
	
			--    ,        
			--       (NumberPlanId=@ExtRouteId )  
			--     (ExtRoutes)
			SELECT TOP 1 @id=Id, @prefix=Prefix FROM ExtRoutes 
			WHERE RightId=@extrouteid AND @mobphone LIKE Prefix+'%' 
			ORDER BY LEN(Prefix) DESC;

			IF(@id<>0) --   (ID)    ,    
				--       (@prefix)
				INSERT INTO @route
					SELECT ReplacePrefix+RIGHT(@mobphone,LEN(@mobphone)-LEN(@prefix)),
						g.GwName,g.Dns,g.ipPort,'',Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
						g.Proto,g.fastStart,g.NoNatProxy,g.MinJittBuf,
						Departments.Description,ANI,Login,Password,
						@CalledUserId,@dspname,@phonenum,@routemask,@internal,
						'',0,@FirstRing,@LastRing,@CalledUserId,
						'',@extrouteid,'',@CalledUserId,'',0,'',0,'',0 
					FROM ExtRoutes AS e, Departments, ExtGateways AS g, CodecClass
					WHERE e.RightId=@extrouteid AND Prefix=@prefix AND Departments.Id=@departmentid AND 
						e.GwId=g.Id AND CodecClassId=CodecClass.Id
					ORDER BY Priority ASC; 
		END
	END

	SELECT * FROM @route;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteInterDep ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteInterDep ] 
	@CalledNumber nvarchar(32),			--  
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@InitRouteMask int
AS
BEGIN
	DECLARE @id int;
	DECLARE @prefix nvarchar(32);

	SET @id=0;

	SELECT TOP 1 @id=Id, @prefix=Prefix 
	FROM InterDepartments 
	WHERE @CalledNumber LIKE Prefix+'%' AND 
		DepartmentId=(@InitRouteMask & 65535) 
		ORDER BY Prefix DESC;

	IF(@id<>0) --   (ID)    ,    
	BEGIN
		SET @CalledNumber=RTRIM(@CalledNumber);	--  ,    

		SELECT ReplacePrefix+RIGHT(@CalledNumber,LEN(@CalledNumber)-LEN(@prefix)),
			GwName,Dns,ipPort,'',
			Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
			Proto,fastStart,NoNatProxy,MinJittBuf,
			@InitDisplayName,@InitPhoneNumber,'','',
			0,@InitDisplayName,@InitPhoneNumber,DepDepId,0,'',0,0,100,0,
			'',0,'',0,'',0,'',0,'',0 
		FROM InterDepartments, CodecClass, ExtGateways 
		WHERE Prefix=@prefix AND InterDepartments.DepartmentId=(@InitRouteMask & 65535) AND GwName='NextCall' AND CodecClass.Id=ExtGateways.CodecClassId;
	END
END

GO
/****** Object:  StoredProcedure [dbo].[RouteInternal ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteInternal ]
	@CalledNumber nvarchar(32),			--   ,     
	@InitUserId int,
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@InitInternal int,
	@InitRouteMask int,
	@PayUserId int,
	@AcsId int
AS
BEGIN
	DECLARE @route table(called varchar(32),gwname varchar(80),dns varchar(128),ipport int,contactaddr varchar(80),
			codec1 int,codec2 int,codec3 int,codec4 int,frame1 int,frame2 int,frame3 int,frame4 int,
			proto int, faststart int, nonatproxy bit, minjittbuff int,
			dispinfo varchar(80),calling varchar(32),
			ulogin varchar(80),passwd varchar(80),
			userid int,dispname varchar(80),
			phone varchar(32),routemask int,internal int,
            userdata  varchar(128),resolvetime int,firstring int,lastring int,
			extid int,str1 varchar(32),int1 int,str2 varchar(32),int2 int,
			str3 varchar(32),int3 int,str4 varchar(32),int4 int,str5 varchar(32),int5 int);

	DECLARE @DepartmentId int;
	DECLARE @phoneid int,@userid int, @firstring int, @lastring int;
	DECLARE @SessId int;
	
	SET @DepartmentId=@InitRouteMask & 65535;
	SET @phoneid=0;

	SELECT @SessId=SessId FROM Connections WHERE AcsId=@AcsId;

	SELECT @InitDisplayName=DisplayInfo+'-'+PhoneNumber FROM Connections WHERE SessId=@SessId AND Line=34 AND Internal=0;

	SELECT @phoneid=Id FROM GroupPhones WHERE PhoneNumber=@CalledNumber AND DepartmentId=@DepartmentId;

	IF(@phoneid<>0)
	BEGIN
		DECLARE groupnum_cursor CURSOR FOR
			SELECT UserId, FirstGroupRing, LastGroupRing 
			FROM GroupRoutes WHERE PhoneId=@phoneid
			ORDER BY FirstGroupRing, LastGroupRing;

		OPEN groupnum_cursor;
		FETCH NEXT FROM groupnum_cursor INTO @userid, @firstring, @lastring;
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @route
				EXEC RouteGroup @userid,@InitDisplayName,@InitPhoneNumber,@firstring,@lastring;
			FETCH NEXT FROM groupnum_cursor INTO @userid, @firstring, @lastring;
		END
		CLOSE groupnum_cursor;
		DEALLOCATE groupnum_cursor;
		SELECT * FROM @route;
	END
	ELSE IF(@PayUserId<>0 AND @InitUserId<>@PayUserId)
	BEGIN
		SELECT @userid=UserId FROM Users, RightGroups
		WHERE PhoneNumber=@CalledNumber AND 
			RightGroups.DepartmentId=@DepartmentId AND RightId=RightGroups.Id;
		EXEC RouteGroup @userid,@InitDisplayName,@InitPhoneNumber,0,50;
	END
	ELSE 
		EXEC RouteUser @CalledNumber,@InitDisplayName,@InitPhoneNumber,@InitInternal,@DepartmentId;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteIntGate]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteIntGate] 
	@CalledNumber nvarchar(32),			--  
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@InitRouteMask int
AS
BEGIN
	DECLARE @id int;
	DECLARE @gwid int;
	DECLARE @prefix nvarchar(32);
	DECLARE @repprefix nvarchar(32);

	SET @id=0;

	SELECT TOP 1 @id=Id, @gwid=GwId, @prefix=Prefix, @repprefix=ReplacePrefix
	FROM IntRoutes 
	WHERE @CalledNumber LIKE Prefix+'%' AND 
		DepartmentId=(@InitRouteMask & 65535) 
		ORDER BY Prefix DESC;

	IF(@id<>0) --   (ID)    ,    
	BEGIN
		SET @CalledNumber=RTRIM(@CalledNumber);	--  ,    

		SELECT @repprefix+RIGHT(@CalledNumber,LEN(@CalledNumber)-LEN(@prefix)),
				IntGateways.GwName,Dns,ipPort,ContactAddr,
			    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
			    Proto,fastStart,NoNatProxy,MinJittBuf,
				@InitDisplayName,@InitPhoneNumber,
				'Login'=CASE WHEN ExpiresInterval<>0 THEN Login ELSE '' END,
				'Password'=CASE WHEN ExpiresInterval<>0 THEN Password ELSE '' END,
				IntGateways.Id+0x10000000,@InitDisplayName,@InitPhoneNumber,DepartmentId,1,
					'',0,0,100,0,'',0,'',0,'',0,'',0,'',0 
		FROM IntGateways, CodecClass, RightGroups
		WHERE CodecClassId=CodecClass.Id AND @gwid=IntGateways.Id AND IntGateways.RightId=RightGroups.Id;
	END
END

GO
/****** Object:  StoredProcedure [dbo].[RoutePlayWav ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RoutePlayWav ]
	@CalledNumber nvarchar(32),
	@InitRouteMask int
--    -  .
AS
BEGIN
	SELECT TOP 1 Forward, WavFileName FROM WavFiles 
	WHERE @CalledNumber=Phone AND (DepartmentId=(@InitRouteMask & 65535) OR DepartmentId=-1) 
	ORDER BY DepartmentId DESC;
END

GO
/****** Object:  StoredProcedure [dbo].[RoutePttConf]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
Create PROCEDURE [dbo].[RoutePttConf]
	@CalledNumber nvarchar(32),			--   ,     
	@InitUserId int,
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@InitInternal int,
	@InitRouteMask int,
	@PayUserId int
AS
BEGIN
	DECLARE @route table(called varchar(32),gwname varchar(80),dns varchar(128),ipport int,contactaddr varchar(80),
			codec1 int,codec2 int,codec3 int,codec4 int,frame1 int,frame2 int,frame3 int,frame4 int,
			proto int, faststart int, nonatproxy bit, minjittbuff int,
			dispinfo varchar(80),calling varchar(32),
			ulogin varchar(80),passwd varchar(80),
			userid int,dispname varchar(80),
			phone varchar(32),routemask int,internal int,
            userdata  varchar(128),resolvetime int,firstring int,lastring int,
			extid int,str1 varchar(32),int1 int,str2 varchar(32),int2 int,
			str3 varchar(32),int3 int,str4 varchar(32),int4 int,str5 varchar(32),int5 int);

	DECLARE @DepartmentId int;
	DECLARE @phoneid int,@userid int;
	DECLARE @DisplayInfo varchar(80);
	DECLARE @MaxConfTime int;
	DECLARE @GongFlag bit;
	DECLARE @GwId int;
	DECLARE @Init int;

	SET @DepartmentId=@InitRouteMask & 65535;
	SET @phoneid=0;

	SELECT @phoneid=Id, @DisplayInfo=DisplayInfo, @MaxConfTime=MaxConfTime, @GongFlag=GongFlag, @GwId=GwId
		FROM ConfPttPhones WHERE ConfPhoneNumber=@CalledNumber AND DepartmentId=@DepartmentId;

	IF(@phoneid<>0 AND EXISTS(SELECT UserId FROM ConfPttRoutes WHERE PhoneId=@phoneid AND UserId=@InitUserId))
	BEGIN
		DECLARE groupnum_cursor CURSOR FOR
			SELECT UserId
			FROM ConfPttRoutes WHERE PhoneId=@phoneid;

		OPEN groupnum_cursor;
		FETCH NEXT FROM groupnum_cursor INTO @userid;
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF(@userid<>@InitUserId)
			BEGIN
				INSERT INTO @route
					EXEC RouteUserConf @userid,@DisplayInfo,@CalledNumber,@MaxConfTime,@GongFlag,@GwId;
			END
			FETCH NEXT FROM groupnum_cursor INTO @userid;
		END
		CLOSE groupnum_cursor;
		DEALLOCATE groupnum_cursor;
		SELECT * FROM @route;
	END
END

GO
/****** Object:  StoredProcedure [dbo].[RouteSetFastForward ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteSetFastForward ]
	@CalledNumber nvarchar(32),
	@Uid int
AS
BEGIN
	IF(@Uid=0)
		BEGIN
			SELECT -1;
			RETURN;
		END

	DECLARE @routemode int;

	SET @routemode=7;


	IF(@CalledNumber='1') SET @CalledNumber='';
	ELSE IF(@CalledNumber='2') SET @CalledNumber='wav_dinner';
	ELSE IF(@CalledNumber='3') SET @CalledNumber='wav_negotiation';
	ELSE IF(@CalledNumber='4') SET @CalledNumber='wav_absent';
	ELSE IF(@CalledNumber='5') SET @CalledNumber='wav_remote';
	ELSE IF(@CalledNumber='6') SET @CalledNumber='wav_rest';
	ELSE SET @routemode=-1;

	IF(@routemode=7)
		UPDATE Users SET Forward=@CalledNumber WHERE UserId=@Uid;

	SELECT @routemode;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteSetFirstRing ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteSetFirstRing ]
	@CalledNumber nvarchar(32),
	@UserId int
AS
BEGIN
	IF(@UserId=0)
	BEGIN
		SELECT -1;
		RETURN;
	END

	DECLARE @routemode int;
	DECLARE @firstdigit int;
	DECLARE @firstring int;

	SET @routemode=7;
	SET @firstdigit=CAST(LEFT(@CalledNumber,1) AS INT);
	SET @firstring=CAST(RIGHT(@CalledNumber,2) AS INT);

	IF(@firstdigit=1) UPDATE Users SET IndProfLineBeg=@firstring WHERE UserId=@UserId;
	ELSE IF(@firstdigit=2) UPDATE Users SET IndProfSoftPhBeg=@firstring WHERE UserId=@UserId;
	ELSE IF(@firstdigit=3) UPDATE Users SET IndProfMobBeg=@firstring WHERE UserId=@UserId;
	ELSE IF(@firstdigit=4) UPDATE Users SET IndProfVoiceMail=@firstring WHERE UserId=@UserId;
	ELSE SET @routemode=-1;

	SELECT @routemode;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteSetForward ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteSetForward ]
	@CalledNumber nvarchar(32),
	@UserId int
AS
BEGIN
	IF(@UserId=0)
	BEGIN
		SELECT -1;
		RETURN;
	END

	UPDATE Users SET Forward=@CalledNumber WHERE UserId=@UserId;
	SELECT 7;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteSetGroupLine ]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteSetGroupLine ]
	@CalledNumber nvarchar(32),
	@UserId int
AS
BEGIN
	IF(@UserId=0)
	BEGIN
		SELECT -1;
		RETURN;
	END

	DECLARE @routemode int;

	SET @routemode=7;

	IF(@CalledNumber='10') UPDATE Users SET GroupLine=0 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='11') UPDATE Users SET GroupLine=1 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='20') UPDATE Users SET GroupSoftPh=0 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='21') UPDATE Users SET GroupSoftPh=1 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='30') UPDATE Users SET GroupMob=0 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='31') UPDATE Users SET GroupMob=1 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='00') UPDATE Users SET GroupLine=0,GroupSoftPh=0 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='01') UPDATE Users SET GroupLine=1,GroupSoftPh=1 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='80') UPDATE Users SET DisableExtCall=0 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='81') UPDATE Users SET DisableExtCall=1 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='90') UPDATE Users SET SecondRing=0 WHERE UserId=@UserId;
	ELSE IF(@CalledNumber='91') UPDATE Users SET SecondRing=1 WHERE UserId=@UserId;
	ELSE SET @routemode=-1;

	SELECT @routemode;
END

GO
/****** Object:  StoredProcedure [dbo].[RoutesGetNumberOfRow]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RoutesGetNumberOfRow]
AS
BEGIN
	SELECT COUNT(*) FROM Routes, RequestRoutes
	WHERE RequestRoutes.Id=Routes.RequestId
END

GO
/****** Object:  StoredProcedure [dbo].[RoutesGetTable]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Author: <Author,,Name>

-- Create date: <Create Date,,>

-- Description: <Description,,>

-- =============================================

CREATE PROCEDURE [dbo].[RoutesGetTable]

AS

BEGIN

SELECT Routes.Id, Prefix, Length, CutPref, 
(Mask*65536+(DepartmentId&65535)), Mode, RequestNum, ReplacePref

FROM Routes, RequestRoutes

WHERE RequestRoutes.Id=Routes.RequestId

END

GO
/****** Object:  StoredProcedure [dbo].[RouteUser]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteUser]
	@CalledNumber nvarchar(32),
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@InitInternal int,
	@DepartmentId int
AS
BEGIN
	DECLARE @route table(called varchar(32),gwname varchar(80),dns varchar(128),ipport int,contactaddr varchar(80),
			codec1 int,codec2 int,codec3 int,codec4 int,frame1 int,frame2 int,frame3 int,frame4 int,
			proto int, faststart int, nonatproxy bit, minjittbuff int,
			dispinfo varchar(80),calling varchar(32),
			ulogin varchar(80),passwd varchar(80),
			userid int,dispname varchar(80),
			phone varchar(32),routemask int,internal int,
            userdata  varchar(128),resolvetime int,firstring int,lastring int,
			extid int,str1 varchar(32),int1 int,str2 varchar(32),int2 int,
			str3 varchar(32),int3 int,str4 varchar(32),int4 int,str5 varchar(32),int5 int);

	DECLARE @forward nvarchar(32);
	DECLARE @userid int;
	DECLARE @dspname nvarchar(80);
	DECLARE @phonenum nvarchar(32);
	DECLARE @internal int;
	DECLARE @routemask int;
	DECLARE @extrouteid int;
	DECLARE @mobphone nvarchar(32);
	DECLARE @secring bit;
	DECLARE @frsp int;
	DECLARE @lrsp int;
	DECLARE @frline int;
	DECLARE @lrline int;
	DECLARE @frmob int;
	DECLARE @lrmob int;
	DECLARE @frfax int;
	DECLARE @lrfax int;
	DECLARE @CodecClassId int;
	DECLARE @MinJittBuf int;

	SET @forward='';
	SET @userid=0;
	SET @extrouteid=0;

	SELECT @userid=UserId, @dspname=Name,@phonenum=PhoneNumber,
		   @internal=Internal,@routemask=(RouteMask*65536+@DepartmentId),
		   @extrouteid=RightId,@secring=SecondRing,@forward=Forward,
		   @mobphone=MobileNumber,
		   @frsp=IndProfSoftPhBeg,@lrsp=20,
		   @frline=IndProfLineBeg,@lrline=20,
		   @frmob=IndProfMobBeg,@lrmob=20,
		   @frfax=IndProfVoiceMail,@lrfax=20,
		   @CodecClassId=CodecClassId, @MinJittBuf=MinJittBuf 
	FROM Users, RightGroups
	WHERE PhoneNumber=@CalledNumber AND RightGroups.DepartmentId=@DepartmentId AND 
		RightId=RightGroups.Id  AND (@InitInternal<>0 OR DisableExtCall=0);

	IF(LEN(@forward)<>0)
		INSERT INTO @route
			SELECT @forward,
				GwName,Dns,ipPort,'',
				Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
				Proto,fastStart,NoNatProxy,MinJittBuf,
				@InitDisplayName,@InitPhoneNumber,
				'','',@userid,@dspname,@phonenum,@routemask,@internal,
				'',0,0,10,0,'',@extrouteid,'',0,'',0,'',0,'',0 
				FROM CodecClass, ExtGateways WHERE GwName='NextCall' AND CodecClass.Id=ExtGateways.CodecClassId;
	ELSE IF(@userid<>0)
	BEGIN
		IF(@lrsp>@frsp)
			INSERT INTO @route
				SELECT ContactPhone,
					RTRIM('User:'+CAST(@userid AS VARCHAR)),Dns,ipPort,ContactAddr,
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,1,1,0,@MinJittBuf,
					@InitDisplayName,@InitPhoneNumber,'','',
					@userid,@dspname,@phonenum,@routemask,@internal,
					'',0,@frsp,@lrsp,0,'',@extrouteid,'',0,'',0,'',0,'',0
				FROM CodecClass, UsersGateways 
				WHERE Id=@CodecClassId AND UserId=@userid AND Expires>=GETDATE();
 		IF(@lrline>@frline)
			INSERT INTO @route
				SELECT PortNumber,'Line:'+IntGateways.GwName,Dns,ipPort,ContactAddr,
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
				    Proto,fastStart,NoNatProxy,MinJittBuf,
					@InitDisplayName,@InitPhoneNumber,
					'Login'=CASE WHEN ExpiresInterval<>0 THEN Login ELSE '' END,
					'Password'=CASE WHEN ExpiresInterval<>0 THEN Password ELSE '' END,
					@userid,@dspname,@phonenum,@routemask,@internal,
					'',0,@frline,@lrline,0,'',@extrouteid,'',0,'',0,'',0,'',0 
				FROM Lines, IntGateways, CodecClass
				WHERE UserId=@userid AND Lines.GwId=IntGateways.Id AND 
					(LEN(Login)=0 OR Expires>=GETDATE()) AND CodecClassId=CodecClass.Id;

		IF(@lrmob>@frmob)
			INSERT INTO @route
				EXEC RouteExternal @mobphone,-1,@extrouteid,0,@userid,
					 @userid,@dspname,@phonenum,@routemask,@internal,@extrouteid,@frmob,@lrmob,@userid;

		IF(@lrfax>@frfax)
			BEGIN
				INSERT INTO @route
			 	 SELECT CAST(@userid AS nvarchar(32))+'#','Line:FaxVoiceServer','127.0.0.1',1730,'',
					2,3,0,0,20,20,0,0,0,1,0,0,
					@InitDisplayName,@InitPhoneNumber,'','',
					@userid,@dspname+':VoiceMail',@phonenum,0,0,
					'',0,@frfax,@lrfax,0,'',0,'',0,'',0,'',0,'',0; 
			END
	END

	IF(@secring<>0)
		INSERT INTO @route
			SELECT @phonenum,'','secondring',0,'',
				   0,0,0,0,0,0,0,0,0,0,0,0,
				   @InitDisplayName,@InitPhoneNumber,'','',
				   @userid,@dspname,@phonenum,@routemask,@internal,
				   '',0,19,20,0,'',0,'',0,'',0,'',0,'',0;
	
	SELECT * FROM @route;
END

GO
/****** Object:  StoredProcedure [dbo].[RouteUserConf]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[RouteUserConf]
	@CalledUserId int,
	@InitDisplayName nvarchar(80),
	@InitPhoneNumber nvarchar(32),
	@MaxConfTime int,
	@GongFlag int,
	@GwId int
AS
BEGIN
	DECLARE @route table(called varchar(32),gwname varchar(80),dns varchar(128),ipport int,contactaddr varchar(80),
			codec1 int,codec2 int,codec3 int,codec4 int,frame1 int,frame2 int,frame3 int,frame4 int,
			proto int, faststart int, nonatproxy bit, minjittbuff int,
			dispinfo varchar(80),calling varchar(32),
			ulogin varchar(80),passwd varchar(80),
			userid int,dispname varchar(80),
			phone varchar(32),routemask int,internal int,
            userdata  varchar(128),resolvetime int,firstring int,lastring int,
			extid int,str1 varchar(32),int1 int,str2 varchar(32),int2 int,
			str3 varchar(32),int3 int,str4 varchar(32),int4 int,str5 varchar(32),int5 int);

	DECLARE @dspname nvarchar(80);
	DECLARE @phonenum nvarchar(32);
	DECLARE @mobilenumber nvarchar(32);
	DECLARE @routemask int;
	DECLARE @departmentid int;
	DECLARE @pttmode int;
	DECLARE @id int;
	DECLARE @CodecClassId int;
	DECLARE @MinJittBuf int;

	SET @phonenum='NONE';

	--     (@CalledUserId)
	SELECT @dspname=Name,@phonenum=PhoneNumber,@mobilenumber=MobileNumber,
		   @routemask=(RouteMask*65536+DepartmentId),
		   @departmentid=DepartmentId,@pttmode=PttMode,
		   @CodecClassId=CodecClassId, @MinJittBuf=MinJittBuf 
	FROM Users, RightGroups
	WHERE @CalledUserId=UserId AND RightId=RightGroups.Id;

	IF(@phonenum<>'NONE')
	BEGIN
		IF(@pttmode=0) --   
			INSERT INTO @route
				SELECT ContactPhone,
					RTRIM('User:'+CAST(@CalledUserId AS VARCHAR)),Dns,ipPort,ContactAddr,
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,1,1,0,@MinJittBuf,
					@InitDisplayName,@InitPhoneNumber,'','',
					@CalledUserId,@dspname,@phonenum,@routemask,@GongFlag,'',@MaxConfTime,
					0,0,0,'',0,'',0,'',0,'',0,'',0 
				FROM CodecClass, UsersGateways 
				WHERE Id=@CodecClassId AND UserId=@CalledUserId AND Expires>=GETDATE();
		ELSE IF (@pttmode=1)
			INSERT INTO @route
				SELECT PortNumber,'Line:'+IntGateways.GwName,Dns,ipPort,ContactAddr,
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
				    Proto,fastStart,NoNatProxy,MinJittBuf,
					@InitDisplayName,@InitPhoneNumber,'','',
					@CalledUserId,@dspname,@phonenum,@routemask,@GongFlag,'',@MaxConfTime,
					0,0,0,'',0,'',0,'',0,'',0,'',0 
				FROM Lines, IntGateways, CodecClass
				WHERE UserId=@CalledUserId AND Lines.GwId=IntGateways.Id AND 
					(LEN(Login)=0 OR Expires>=GETDATE()) AND CodecClassId=CodecClass.Id;
		ELSE 
			INSERT INTO @route
				SELECT @mobilenumber,g.GwName,g.Dns,g.ipPort,'',
				    Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,
					g.Proto,g.fastStart,g.NoNatProxy,g.MinJittBuf,
					g.GwName,Ani,Login,Password,
					@CalledUserId,@dspname,@phonenum,@departmentid,@GongFlag,'',@MaxConfTime,
					0,0,1,'',0,'',0,'',0,'',0,'',0 
				FROM ExtGateways AS g, CodecClass
				WHERE 
					g.Id=@GwId AND CodecClassId=CodecClass.Id;
	END

	SELECT * FROM @route;
END

GO
/****** Object:  StoredProcedure [dbo].[SubscribeSipAuthorize]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[SubscribeSipAuthorize] 
	@SubscrPhone nvarchar(32),
	@DisplayName nvarchar(80),
	@Phone nvarchar(32),
	@Login nvarchar(80),
	@IPaddr nvarchar(16),
	@IPport int,
	@ContactAddr nvarchar(80),
	@Realm nvarchar(80),
	@Uri nvarchar(80),
	@Method nvarchar(32),
	@Nonce nvarchar(33),
	@Response nvarchar(33)
AS
BEGIN
	DECLARE @routemask int;
	DECLARE @UserId int;
	DECLARE @Password nvarchar(80);
	DECLARE @SubcrFlag bit;
	DECLARE @DepartmentId int;
	DECLARE @GwId int;

	SET @Password='';
	SET @SubcrFlag=0;
	SET @UserId=0;
	SET @GwId=0;

	SELECT TOP 1 @UserId=UserId,@Password=Password FROM Users WHERE Login=@Login;
	
	IF(@UserId<>0 AND @Password<>'')
	BEGIN
		IF (dbo.DigestAuthorizeMD5(@Login,@Password,@Realm,@Uri,@Method,@Nonce,@Response)<>'true')
		BEGIN
			SELECT -1;
			RETURN;
		END

		SELECT TOP 1  @routemask=(RouteMask*65536+RightGroups.DepartmentId), @DepartmentId=RightGroups.DepartmentId
		FROM Users, RightGroups
		WHERE UserId=@UserId AND RightId=RightGroups.Id AND Internal<>0;

		SET @SubcrFlag=0;
		SELECT @SubcrFlag=Internal FROM Users WHERE @UserId=UserId AND @SubscrPhone IN (SELECT PhoneNumber FROM Users, RightGroups WHERE RightId=RightGroups.Id AND RightGroups.DepartmentId=@DepartmentId);
		IF(@SubcrFlag=0) SET @routemask=0;
		SELECT @routemask;
		RETURN;
	END

	SELECT TOP 1 @GwId=Id,@Password=Password FROM IntGateways WHERE Login=@Login;

	IF(@GwId<>0 AND @Password<>'')
	BEGIN
		IF (dbo.DigestAuthorizeMD5(@Login,@Password,@Realm,@Uri,@Method,@Nonce,@Response)<>'true')
		BEGIN
			SELECT -1;
			RETURN;
		END

		SELECT TOP 1  @Phone=Users.PhoneNumber, @UserId=Users.UserId, @routemask=(RouteMask*65536+RightGroups.DepartmentId), @DepartmentId=RightGroups.DepartmentId
		FROM Lines, Users, RightGroups
		WHERE Lines.GwId=@GwId AND Lines.PortNumber=@Phone AND Users.UserId=Lines.UserId AND 
		  RightId=RightGroups.Id AND Users.Internal<>0;

		SET @SubcrFlag=0;
		SELECT @SubcrFlag=Internal FROM Users WHERE @UserId=UserId AND @SubscrPhone IN (SELECT PhoneNumber FROM Users, RightGroups WHERE RightId=RightGroups.Id AND RightGroups.DepartmentId=@DepartmentId);
		IF(@SubcrFlag=0) SET @routemask=0;
		SELECT @routemask;
		RETURN;
	END

	SELECT 0;
END

GO
/****** Object:  UserDefinedFunction [dbo].[DigestAuthorizeMD5]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [dbo].[DigestAuthorizeMD5] 
(
	@Login nvarchar(80),
	@Password nvarchar(80),
	@Realm nvarchar(80),
	@Uri nvarchar(80),
	@Method nvarchar(32),
	@Nonce nvarchar(33),
	@Response nvarchar(33)
)
RETURNS bit
AS
BEGIN
	DECLARE @HashThis nvarchar(33);
	DECLARE @A1 nvarchar(33);
	DECLARE @A2 nvarchar(33);

	SELECT @A1=SUBSTRING(master.dbo.fn_varbintohexstr(HashBytes('MD5', CONVERT(varchar(240),@Login+':'+@Realm+':'+@Password))),3,32);
	SELECT @A2=SUBSTRING(master.dbo.fn_varbintohexstr(HashBytes('MD5',CONVERT(varchar(112),@Method+':'+@Uri))),3,32);
	SELECT @HashThis=SUBSTRING(master.dbo.fn_varbintohexstr(HashBytes('MD5',CONVERT(varchar(98),@A1+':'+@Nonce+':'+@A2))),3,32);
	
	IF (@Response=@HashThis) return 'true';

	RETURN 'false';

END

GO
/****** Object:  UserDefinedFunction [dbo].[ResolveRouteByTime]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION  [dbo].[ResolveRouteByTime]
(
	 @route_id int,
	 @departid int
)
RETURNS bit
AS
BEGIN
--Route data
		DECLARE @r_id as int;
		DECLARE @cbflag as bit;
		DECLARE @route_ani as nvarchar(32);
		DECLARE @ip_phone_id as int;
--end Route data
		DECLARE @profile_id int;
		DECLARE @W_on_H bit;
		DECLARE @currient_time int;
		DECLARE @currient_date_type int;
		DECLARE @res bit;

		DECLARE @wd_b int;
		DECLARE @wd_e int;
		DECLARE @sd_b int;
		DECLARE @sd_e int;
		DECLARE @ow_b int;
		DECLARE @ow_e int;
		DECLARE @hd_b int;
		DECLARE @hd_e int;

		DECLARE @times table (day_type int,work_beg int,work_end int);
		DECLARE @work_week table (day_number int,day_type int);
-- 

		SET @currient_time=datepart(hh,getdate())*60+datepart(mi,getdate());
		SET @currient_date_type=0;
		
-- 
		SELECT @cbflag=CallBack FROM InCallRoute WHERE id=@route_id;-- CallBack ,    1 () -    .
		
		SELECT @profile_id=id,@wd_b=WorkDayBeg,@wd_e=WorkDayEnd,@sd_b=ShortDayBeg,@sd_e=ShortDayEnd,
				@ow_b=OffWorkDayBeg,@ow_e=OffWorkDayEnd,@hd_b=HolidayBeg,@hd_e=HolidayEnd,@W_on_H=WorkOnHolidays
					 FROM InCallRouteTimeProfiles WHERE id=(SELECT TOP 1 TimeProfileID FROM InCallRoute Where id=@route_id AND CallBack=0);

--   
		INSERT INTO @times VALUES(0,@wd_b,@wd_e);
		INSERT INTO @times VALUES(1,@sd_b,@sd_e);
		INSERT INTO @times VALUES(2,@ow_b,@ow_e);
		INSERT INTO @times VALUES(3,@hd_b,@hd_e);

		INSERT INTO @work_week SELECT 2,mon FROM InCallRouteTimeProfiles WHERE id=@profile_id;;
		INSERT INTO @work_week SELECT 3,tue FROM InCallRouteTimeProfiles WHERE id=@profile_id;;
		INSERT INTO @work_week SELECT 4,wed FROM InCallRouteTimeProfiles WHERE id=@profile_id;;
		INSERT INTO @work_week SELECT 5,thu FROM InCallRouteTimeProfiles WHERE id=@profile_id;;	
		INSERT INTO @work_week SELECT 6,fri FROM InCallRouteTimeProfiles WHERE id=@profile_id;;
		INSERT INTO @work_week SELECT 7,sat FROM InCallRouteTimeProfiles WHERE id=@profile_id;;
		INSERT INTO @work_week SELECT 1,sun FROM InCallRouteTimeProfiles WHERE id=@profile_id;;

		SET @res=0;	
	
		if (@W_on_H=0)
			BEGIN
				SELECT @currient_date_type=Type FROM InCallRouteCalendar WHERE datepart(dd,getdate())=Day AND datepart(mm,getdate())=Month AND DepartmentId=@departid;
				if(@currient_date_type IS NULL)
						SELECT @currient_date_type=Type FROM InCallRouteCalendar WHERE datepart(dd,getdate())=Day AND datepart(mm,getdate())=Month AND DepartmentId=-1 ;
				if(@currient_date_type IS NULL)
						SELECT @currient_date_type=day_type FROM @work_week WHERE day_number=DatePart(dw,getdate());
				
			END	
		ELSE
			BEGIN
				SELECT @currient_date_type=day_type FROM @work_week WHERE day_number=DatePart(dw,getdate());
			END

		SELECT  @wd_b=work_beg, @wd_e=work_end FROM @times WHERE day_type=@currient_date_type;		
		
		IF(@wd_b<@wd_e)
			IF((@wd_b<@currient_time) AND (@wd_e>@currient_time))
					SET @res=1;
				ELSE
					SET @res=0;
		ELSE
			IF((@wd_b<@currient_time) OR (@wd_e>@currient_time))
					SET @res=1;
				ELSE
					SET @res=0;

		IF @cbflag=1
			SET @res=1;
		RETURN @res;
END

GO
/****** Object:  Table [db_owner].[ConfRoutes]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [db_owner].[ConfRoutes](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PhoneId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_ConfRoutes] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ACSDBVersion]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ACSDBVersion](
	[CompanentID] [int] NULL,
	[Version] [nvarchar](40) NULL,
	[Comments] [nvarchar](128) NULL
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[AniRules]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AniRules](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AniTrId] [int] NOT NULL,
	[Prefix] [nvarchar](32) NOT NULL,
	[Len] [int] NOT NULL,
	[TransformRule] [nvarchar](32) NOT NULL,
 CONSTRAINT [PK_AniTransform] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[AniTransform]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AniTransform](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Description] [nvarchar](50) NOT NULL,
	[DepartmentId] [int] NOT NULL,
 CONSTRAINT [PK_AniRules] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[CallDataRecords]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CallDataRecords](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LegId] [int] NULL,
	[InitLegId] [int] NULL,
	[SqlData] [datetime] NOT NULL,
	[DataTime] [int] NULL,
	[UserId] [int] NULL,
	[DepartmentId] [int] NULL,
	[DisplayName] [nvarchar](80) NULL,
	[Phone] [nvarchar](32) NULL,
	[Ani] [nvarchar](32) NULL,
	[Called] [nvarchar](32) NULL,
	[Calling] [nvarchar](32) NULL,
	[Incoming] [bit] NULL,
	[CallBack] [bit] NULL,
	[GwName] [nvarchar](80) NULL,
	[IPaddr] [nvarchar](16) NULL,
	[IPport] [int] NULL,
	[UserData] [nvarchar](128) NULL,
	[InitUserId] [int] NULL,
	[InitDisplayName] [nvarchar](80) NULL,
	[InitPhone] [nvarchar](32) NULL,
	[InitAni] [nvarchar](32) NULL,
	[Duration] [int] NULL,
	[PayUserID] [int] NULL,
	[Codec] [int] NULL,
	[Fax] [bit] NULL,
	[TrmtPack] [int] NULL,
	[TrmtOctet] [int] NULL,
	[RecvPack] [int] NULL,
	[RecvOctet] [int] NULL,
	[RecordFile] [nvarchar](256) NULL,
 CONSTRAINT [PK_CallDataRecords] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[CodecClass]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CodecClass](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Codec1] [int] NULL,
	[Codec2] [int] NULL,
	[Codec3] [int] NULL,
	[Codec4] [int] NULL,
	[Frame1] [int] NULL,
	[Frame2] [int] NULL,
	[Frame3] [int] NULL,
	[Frame4] [int] NULL,
	[ClassName] [nvarchar](80) NULL,
 CONSTRAINT [PK_CodecClass] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ConfPttPhones]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ConfPttPhones](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ConfPhoneNumber] [nvarchar](32) NOT NULL,
	[DepartmentId] [int] NOT NULL,
	[DisplayInfo] [nvarchar](80) NULL,
	[MaxConfTime] [int] NULL,
	[GongFlag] [bit] NULL,
	[GwId] [int] NULL,
 CONSTRAINT [PK_ConfPhones] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ConfPttRoutes]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ConfPttRoutes](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PhoneId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_ConfRoutes_1] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Connections]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Connections](
	[Channel] [int] NULL,
	[Line] [int] NULL,
	[State] [nvarchar](32) NULL,
	[DepartmentId] [int] NULL,
	[UserId] [int] NULL,
	[DisplayInfo] [nvarchar](80) NULL,
	[PhoneNumber] [nvarchar](32) NULL,
	[Handle] [int] NULL,
	[RoutePlan] [int] NULL,
	[Ani] [nvarchar](32) NULL,
	[TransferNumber] [nvarchar](32) NULL,
	[SessId] [int] NULL,
	[AcsId] [int] NULL,
	[IPaddr] [nvarchar](32) NULL,
	[IPport] [int] NULL,
	[InitTime] [datetime] NULL,
	[ConnectTime] [datetime] NULL,
	[Internal] [int] NULL,
	[Incoming] [int] NULL,
	[Mute] [int] NULL,
	[ConfId] [int] NULL,
	[InitUserId] [int] NULL,
	[InitDisplayInfo] [nvarchar](80) NULL,
	[InitPhoneNumber] [nvarchar](32) NULL,
	[InitHandle] [int] NULL,
	[InPhoneId] [int] NULL
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Departments]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Departments](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Description] [nvarchar](80) NOT NULL,
	[MaxChan] [int] NOT NULL,
	[MaxInChan] [int] NOT NULL,
 CONSTRAINT [PK_Departments] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[events]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[events](
	[routes] [int] NULL
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ExtGateways]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ExtGateways](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[GwName] [nvarchar](80) NOT NULL,
	[Dns] [nvarchar](128) NOT NULL,
	[IPaddr] [nvarchar](16) NULL,
	[ipPort] [int] NOT NULL,
	[CodecClassId] [int] NOT NULL,
	[Proto] [int] NOT NULL,
	[fastStart] [int] NOT NULL,
	[NoNatProxy] [bit] NOT NULL,
	[MinJittBuf] [int] NOT NULL,
	[DepartmentId] [int] NOT NULL,
	[Login] [nvarchar](80) NULL,
	[Password] [nvarchar](80) NULL,
	[Ani] [nvarchar](32) NULL,
	[ExpiresInterval] [int] NULL,
	[Register] [bit] NULL,
	[NextRegTime] [datetime] NULL,
	[InPhone] [nvarchar](32) NULL,
	[AniTransId] [int] NULL,
	[MaxChan] [int] NULL,
 CONSTRAINT [PK_ExtGateways] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ExtRoutes]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ExtRoutes](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[RightId] [int] NOT NULL,
	[Prefix] [nvarchar](32) NOT NULL,
	[GwId] [int] NOT NULL,
	[Priority] [int] NOT NULL,
	[ReplacePrefix] [nvarchar](32) NOT NULL,
 CONSTRAINT [PK_ExtRoute] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[FaxFileTab]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[FaxFileTab](
	[SessId] [nvarchar](32) NOT NULL,
	[MailNumber] [nvarchar](32) NULL,
	[Mail] [nvarchar](256) NULL,
	[FileName] [nvarchar](256) NULL,
	[ANI] [nvarchar](32) NULL,
	[DisplayInfo] [nvarchar](80) NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_FaxFileTab] PRIMARY KEY CLUSTERED 
(
	[SessId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[GroupPhones]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GroupPhones](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PhoneNumber] [nvarchar](32) NOT NULL,
	[DepartmentId] [int] NOT NULL,
	[ContinueRing] [bit] NOT NULL,
	[DayTime] [time](7) NULL,
 CONSTRAINT [PK_GroupPhones] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[GroupRoutes]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GroupRoutes](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PhoneId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[FirstGroupRing] [int] NOT NULL,
	[LastGroupRing] [int] NOT NULL,
 CONSTRAINT [PK_GroupRoutes] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Intercept]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Intercept](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[GroupId] [int] NOT NULL,
	[DepartmentId] [int] NOT NULL,
	[Phone] [nvarchar](32) NOT NULL,
 CONSTRAINT [PK_Intercept] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[InterceptGroup]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[InterceptGroup](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[GroupName] [nvarchar](50) NOT NULL,
	[DepartmentId] [int] NOT NULL,
 CONSTRAINT [PK_InterceptGroup] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[InterDepartments]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[InterDepartments](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Prefix] [nvarchar](32) NOT NULL,
	[DepDepId] [int] NOT NULL,
	[ReplacePrefix] [nvarchar](32) NOT NULL,
	[DepartmentId] [int] NOT NULL,
 CONSTRAINT [PK_InterDepartment] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[IntGateways]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[IntGateways](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[gwName] [nvarchar](80) NOT NULL,
	[Dns] [nvarchar](128) NOT NULL,
	[ipPort] [int] NOT NULL,
	[Login] [nvarchar](80) NOT NULL,
	[Password] [nvarchar](80) NOT NULL,
	[ContactAddr] [nvarchar](80) NULL,
	[CodecClassId] [int] NOT NULL,
	[Proto] [int] NOT NULL,
	[fastStart] [int] NOT NULL,
	[NoNatProxy] [bit] NOT NULL,
	[MinJittBuf] [int] NOT NULL,
	[RightId] [int] NOT NULL,
	[Expires] [datetime] NULL,
	[NextRegTime] [datetime] NULL,
	[Register] [bit] NULL,
	[ExpiresInterval] [int] NULL,
 CONSTRAINT [PK_IntGateways_1] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[IntRoutes]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[IntRoutes](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Prefix] [nvarchar](32) NULL,
	[GwId] [int] NOT NULL,
	[ReplacePrefix] [nvarchar](32) NULL,
	[DepartmentId] [int] NULL,
 CONSTRAINT [PK_DepRoute] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[LineEvents]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LineEvents](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[EventTime] [datetime] NOT NULL,
	[Connection] [int] NULL,
	[Line] [int] NULL,
	[State] [nvarchar](32) NULL,
	[UserId] [int] NULL,
	[DisplayInfo] [nvarchar](80) NULL,
	[PhoneNumber] [nvarchar](32) NULL,
	[Handle] [int] NULL,
	[RoutePlan] [int] NULL,
	[Ani] [nvarchar](32) NULL,
	[TransferNumber] [nvarchar](32) NULL,
	[SessId] [int] NULL,
	[AcsId] [int] NULL,
	[IPaddr] [nvarchar](32) NULL,
	[IPport] [int] NULL,
	[Internal] [int] NULL,
	[Incoming] [int] NULL,
	[Mute] [int] NULL,
	[ConfId] [int] NULL,
	[Duration] [int] NULL
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Lines]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Lines](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[GwId] [int] NOT NULL,
	[PortNumber] [nvarchar](32) NULL,
	[UserId] [int] NULL,
	[Description] [nvarchar](64) NULL,
 CONSTRAINT [PK_Lines] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[ListWhiteIP]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ListWhiteIP](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[IPaddr] [nvarchar](15) NOT NULL,
 CONSTRAINT [PK_ListWhiteIP] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[RequestRoutes]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[RequestRoutes](
	[Id] [int] NOT NULL,
	[Mode] [int] NOT NULL,
	[RequestNum] [int] NOT NULL,
	[Description] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_RequestRoutes] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[RightGroups]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[RightGroups](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DepartmentId] [int] NOT NULL,
	[RouteMask] [int] NOT NULL,
	[Description] [nvarchar](80) NOT NULL,
 CONSTRAINT [PK_RightGroups] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Routes]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Routes](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Prefix] [nvarchar](32) NOT NULL,
	[Length] [int] NOT NULL,
	[CutPref] [bit] NOT NULL,
	[DepartmentId] [int] NOT NULL,
	[Mask] [int] NOT NULL,
	[RequestId] [int] NOT NULL,
	[ReplacePref] [nvarchar](32) NULL,
 CONSTRAINT [PK_RoutePlan] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Users]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Users](
	[UserId] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
	[PhoneNumber] [nvarchar](32) NOT NULL,
	[Login] [nvarchar](80) NOT NULL,
	[Password] [nvarchar](80) NOT NULL,
	[CodecClassId] [int] NOT NULL,
	[MinJittBuf] [int] NOT NULL,
	[Internal] [bit] NOT NULL,
	[RightId] [int] NOT NULL,
	[MobileNumber] [nvarchar](50) NOT NULL,
	[CallBack] [bit] NULL,
	[Forward] [nvarchar](32) NOT NULL,
	[DisableExtCall] [bit] NOT NULL,
	[SecondRing] [bit] NOT NULL,
	[IndProfSoftPhBeg] [int] NOT NULL,
	[IndProfLineBeg] [int] NOT NULL,
	[IndProfMobBeg] [int] NOT NULL,
	[IndProfVoiceMail] [int] NOT NULL,
	[GroupSoftPh] [bit] NOT NULL,
	[GroupLine] [bit] NOT NULL,
	[GroupMob] [bit] NOT NULL,
	[EMail] [nvarchar](128) NOT NULL,
	[ConfSoftPh] [bit] NULL,
	[ConfLine] [bit] NULL,
	[ConfMob] [bit] NULL,
	[PttMode] [int] NULL,
 CONSTRAINT [PK_users] PRIMARY KEY CLUSTERED 
(
	[UserId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[UsersGateways]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UsersGateways](
	[UserId] [int] NOT NULL,
	[Dns] [nvarchar](128) NOT NULL,
	[ipPort] [int] NOT NULL,
	[ContactAddr] [nvarchar](80) NULL,
	[ContactPhone] [nvarchar](32) NULL,
	[Expires] [datetime] NOT NULL
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[WavFiles]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[WavFiles](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Phone] [nvarchar](32) NOT NULL,
	[WavFileName] [nvarchar](80) NOT NULL,
	[Forward] [nvarchar](32) NOT NULL,
	[DepartmentId] [int] NOT NULL,
 CONSTRAINT [PK_WavFiles] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[WavFileTab]    Script Date: 28.12.2017 20:03:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[WavFileTab](
	[SessId] [nvarchar](32) NOT NULL,
	[MailNumber] [nvarchar](32) NULL,
	[Mail] [nvarchar](256) NULL,
	[FileName] [nvarchar](256) NULL,
	[ANI] [nvarchar](32) NULL,
	[DisplayInfo] [nvarchar](80) NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_WavFileTab] PRIMARY KEY CLUSTERED 
(
	[SessId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
ALTER TABLE [dbo].[CallDataRecords] ADD  CONSTRAINT [DF_CallDataRecords_SqlData]  DEFAULT (getdate()) FOR [SqlData]
GO
ALTER TABLE [dbo].[Intercept] ADD  CONSTRAINT [DF_Intercept_GroupId]  DEFAULT ((0)) FOR [GroupId]
GO
ALTER TABLE [dbo].[Intercept] ADD  CONSTRAINT [DF_Intercept_UserId]  DEFAULT ((0)) FOR [DepartmentId]
GO
ALTER TABLE [dbo].[IntRoutes] ADD  CONSTRAINT [DF_DepRoute_Department]  DEFAULT ((0)) FOR [DepartmentId]
GO
ALTER TABLE [dbo].[Users] ADD  CONSTRAINT [DF_Users_Department]  DEFAULT ((0)) FOR [RightId]
GO
ALTER TABLE [dbo].[WavFiles] ADD  CONSTRAINT [DF_WavFiles_Department]  DEFAULT ((0)) FOR [DepartmentId]
GO
ALTER TABLE [dbo].[ExtGateways]  WITH CHECK ADD  CONSTRAINT [FK_Gateways_CodecClass] FOREIGN KEY([CodecClassId])
REFERENCES [dbo].[CodecClass] ([Id])
ON UPDATE CASCADE
GO
ALTER TABLE [dbo].[ExtGateways] CHECK CONSTRAINT [FK_Gateways_CodecClass]
GO
ALTER TABLE [dbo].[Intercept]  WITH CHECK ADD  CONSTRAINT [FK_Intercept_InterceptGroup] FOREIGN KEY([GroupId])
REFERENCES [dbo].[InterceptGroup] ([Id])
ON UPDATE CASCADE
GO
ALTER TABLE [dbo].[Intercept] CHECK CONSTRAINT [FK_Intercept_InterceptGroup]
GO
ALTER TABLE [dbo].[IntGateways]  WITH CHECK ADD  CONSTRAINT [FK_IntGateways_CodecClass] FOREIGN KEY([CodecClassId])
REFERENCES [dbo].[CodecClass] ([Id])
ON UPDATE CASCADE
GO
ALTER TABLE [dbo].[IntGateways] CHECK CONSTRAINT [FK_IntGateways_CodecClass]
GO
ALTER TABLE [dbo].[RightGroups]  WITH CHECK ADD  CONSTRAINT [FK_RightGroups_Departments] FOREIGN KEY([DepartmentId])
REFERENCES [dbo].[Departments] ([Id])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[RightGroups] CHECK CONSTRAINT [FK_RightGroups_Departments]
GO
ALTER TABLE [dbo].[Users]  WITH CHECK ADD  CONSTRAINT [FK_Users_RightGroups] FOREIGN KEY([RightId])
REFERENCES [dbo].[RightGroups] ([Id])
ON DELETE CASCADE
GO
ALTER TABLE [dbo].[Users] CHECK CONSTRAINT [FK_Users_RightGroups]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'       ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ExtGateways', @level2type=N'CONSTRAINT',@level2name=N'FK_Gateways_CodecClass'
GO



USE [IronPbx]
GO
INSERT INTO Departments (Description,MaxChan,MaxInChan)
    VALUES('Admin',16,16);
GO
INSERT INTO events (routes) VALUES(1);
GO
INSERT INTO CodecClass (Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,ClassName) 
	VALUES(2,3,0,0,20,20,0,0,'Local network');
GO
INSERT INTO CodecClass (Codec1,Codec2,Codec3,Codec4,Frame1,Frame2,Frame3,Frame4,ClassName) 
	VALUES(6,7,5,1,2,1,1,1,'External network');
GO
INSERT INTO RightGroups (DepartmentId,RouteMask,Description) 
     VALUES (1,1,'AllUsers');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(0,7,0,'  ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(1,4,1,'    ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(2,2,2,'    ( )');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(3,4,3,'   ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(4,8,4,' ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(5,6,5,'    ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(6,6,6,'   ( )');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(7,11,7,'CallBack,    ''cb''');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(8,-1,8,'  -');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(9,-1,9,' ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(10,-1,10,'    ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(11,-1,11,'   ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(12,-1,12,'  (,  ...)');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(13,3,13,'  FaxVoiceServer - ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(14,4,14,'    ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(15,19,15,' PTT');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(16,4,16,'   ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(17,18,17,'    ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(18,14,18,' ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(19,9,19,'   ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(20,15,20,'    ');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(21,13,21,'  HANDLE');
GO
INSERT INTO RequestRoutes(Id,Mode,RequestNum,Description)
     VALUES(22,3,17,'  ');

GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('1',3,0,1,0,1,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('pbx',3,0,-1,0,0,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('wav_',0,1,-1,0,4,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('cb',0,1,-1,0,7,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('a',4,1,-1,0,17,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('b',4,1,-1,0,22,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('c',3,1,-1,0,19,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('q',10,1,-1,0,21,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('8',11,0,1,1,2,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('+7',12,1,1,1,2,'8');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('810',0,1,1,1,2,'+');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('+',0,0,1,1,2,'');
GO
INSERT INTO Routes(Prefix,Length,CutPref,DepartmentId,Mask,RequestId,ReplacePref)
     VALUES('pickup',9,1,-1,0,6,'');
